#include "SGReseau.h"

SGReseau *SGReseau::s_pSGReseau;

// Constructeur par dfaut
SGReseau::SGReseau()
{
    this->m_pListeEvents = new ListeChainee<CellEvent>;
    this->m_pListeRxEvents = new ListeChainee<CellEvent>;
    this->m_pListeJoueurs = new ListeChainee<CellJoueur>;
    s_pSGReseau = this;
}
// Destructeur
SGReseau::~SGReseau()
{
    delete (this->m_pListeRxEvents);
    delete (this->m_pListeEvents);
    delete (this->m_pListeJoueurs);
}
        
// Envoi la liste des vnements et attend de recevoir
// liste d'vnements des autres joueurs
void SGReseau::updateReseau()
{
     char * cEvents = new char[1000];
     char * cCourant;
     cCourant = cEvents;
     int iNbOctets = 0;
     int iRet;
     int i = 0;
     char cNumJoueur;
     
     this->m_pListeRxEvents->debut();
     
     if (this->m_pListeRxEvents->getCourant() != NULL)
     {
        do
         {
            iNbOctets++;
            (*cCourant++) = this->m_pListeRxEvents->getCourant()->cNumEvent;
        } while(this->m_pListeRxEvents->suivant());
        
     }
     iNbOctets++;
     *cCourant=0;
     
     iRet = send(this->m_Sock, cEvents, iNbOctets, 0);
     if (iRet == -1)
     {
          printf("Erreur lors de l'envoi de la liste d'evenements au serveur\n");
          //exit(1);
     }
     
     this->m_pListeRxEvents->vider();
     this->m_pListeEvents->vider();
     
     
     iRet = recv(this->m_Sock, cEvents, sizeof(char[1000]), 0);
     if (iRet == -1)
     {
          printf("Erreur lors de la reception de la liste d'evenements\n");
          //exit(2);
     }
          
     if (iRet != 0)
     {
        // iRet - 1 vient du fait que l'on ne prend pas en compte le
        // dernier octet qui est toujours egal a zero
        for (i = 0, cCourant = cEvents; i < iRet-1; i++, cCourant++)
        {
            if(i==0)
            {
                cNumJoueur = *cCourant;
            }
            else
            {
                if(*cCourant !=0)
                {
                    addEvent(cNumJoueur, *cCourant);
                }
                else
                {
                    i++;
                    cNumJoueur= *(++cCourant);
                }
            }
        }
    }     
}

// Connecte la machine au seveur qui lui renvoie
// son numro de joueur
void SGReseau::connectServ(char * szHostName, char * szNomJoueur)
{
    WSADATA WSAData;
    WSAStartup(MAKEWORD(2,0), &WSAData);
    int iRet;
    char buffer[100];
    hostent * serveur;
    char cNumJoueur;
    char cNbJoueurs;
    
    this->m_Sock = socket(AF_INET,SOCK_STREAM,0);
    if (this->m_Sock == -1)
    {
        printf("erreur de creation de socket !\n");
        //exit(1);
    }
    
    //serveur = gethostbyname(szHostName);
    //memcpy(serveur->h_addr, &this->m_Sin.sin_addr.s_addr, serveur->h_length);
    this->m_Sin.sin_addr.s_addr = inet_addr(szHostName);
    this->m_Sin.sin_family = AF_INET;
    this->m_Sin.sin_port = htons(23023);
        
    iRet = connect(this->m_Sock, (SOCKADDR*) &this->m_Sin, sizeof(this->m_Sin));
    if (iRet == -1)
    {
        printf("Erreur de connexion\n");
        //exit(1);
    }
    
    iRet = recv(this->m_Sock, &cNumJoueur, sizeof(cNumJoueur), 0);
    if (iRet == -1)
    {
         printf("Erreur lors de la reception du numro de joueur\n");
         //exit(2);
    }
    this->m_cNumJoueur = cNumJoueur;
    
    iRet = recv(this->m_Sock, &cNbJoueurs, sizeof(cNbJoueurs), 0);
    if (iRet == -1 )
    {
         printf("Erreur lors de la reception du nombre de joueurs\n");
         //exit(3);
    }
    this->m_iNbJoueurs = cNbJoueurs;
    
    // Assigne le nom du joueur et l'ajoute dans la liste
    CellJoueur * cellule;
    cellule = new CellJoueur;
    cellule->cNumJoueur = this->m_cNumJoueur;
    cellule->szNomJoueur = new char[50];
    strcpy(cellule->szNomJoueur, szNomJoueur);
    //printf("Ajout nom joueur %d : %s\n",this->m_cNumJoueur,cellule->szNomJoueur);
    this->m_pListeJoueurs->add(cellule, NULL);
    
    // envoi du nom du joueur
    iRet = send(this->m_Sock, szNomJoueur, strlen(szNomJoueur)*sizeof(char), 0);
    if (iRet == -1)
    {
        printf("Erreur d envoi du nom de joueur\n");
        //exit(4);
    }
    
}

// Dconnecte la machine du serveur
void SGReseau::disconnect()
{
    closesocket(this->m_Sock);
    WSACleanup();
}

// Ajoute un vnement  la liste d'vnements
void SGReseau::addRxEvent(char cNumJoueur, char cNumEvent)
{
    CellEvent * cellule;
    cellule = new CellEvent;
    cellule->cNumJoueur = cNumJoueur;
    cellule->cNumEvent = cNumEvent;
    this->m_pListeRxEvents->add(cellule, NULL ); 
}

// Ajoute un vnement  la liste d'vnements
void SGReseau::addEvent(char cNumJoueur, char cNumEvent)
{
    CellEvent * cellule;
    cellule = new CellEvent;
    cellule->cNumJoueur = cNumJoueur;
    cellule->cNumEvent = cNumEvent;
    this->m_pListeEvents->add(cellule, NULL );
}

// Retourne VRAI si l'vnement cNumEvent s'est produit
// Retourne FAUX sinon
bool SGReseau::testEvent(char cNumJoueur, char cNumEvent)
{
    this->m_pListeEvents->debut();
    if (this->m_pListeEvents->getCourant() == NULL)
        return false;
    
    CellEvent *courant;
    
    do
    {
        courant = this->m_pListeEvents->getCourant();
        if (courant->cNumEvent == cNumEvent && courant->cNumJoueur == cNumJoueur)
        {
            return true;
        }
    }while (this->m_pListeEvents->suivant());
    return false;
}

// informe le serveur que le joueur est pret
void SGReseau::ready()
{
    int iRet;
    char *c = new char[50];
    strcpy(c,"ready\n");
    iRet = send(this->m_Sock, c, strlen(c)*sizeof(char),0);
    if (iRet == -1)
    {
        printf("Erreur lors de l envoi du ready\n");
        //exit(1);
    }
    delete c;
 /*   c = this->m_pListeJoueurs->get(0)->szNomJoueur;
    
    iRet = send(this->m_Sock, c, sizeof(c), 0);
    if (iRet == -1)
    {
        printf("Erreur lors de l envoi du nom de joueur\n");
        //exit(2);
    }
    delete c;*/
    c =new char[50];
    
    CellJoueur * cellule;
            
    for(int i = 0; i < this->m_iNbJoueurs - 1; i++)
    {
        cellule = new CellJoueur;
        cellule->szNomJoueur = new char[50];
        //reception du numero du joueur
        iRet = recv(this->m_Sock, c, sizeof(char), 0);
        if (iRet == -1)
        {
            printf("Erreur lors de la reception du numro de l'un des joueurs\n");
            //exit(3);
        }
        cellule->cNumJoueur = (char) *c;  
        //reception du nom      
        iRet = recv(this->m_Sock, c, sizeof(char[50]), 0);
        if (iRet == -1)
        {
            printf("Erreur lors de la reception du nom de l'un des joueurs\n");
            //exit(4);
        }
        c[iRet]='\0';
        strcpy(cellule->szNomJoueur, c);
        this->m_pListeJoueurs->add(cellule, cellule->szNomJoueur); 
        
        //envoi de l'acus de reception
        strcpy(c,"ok");
        iRet = send(this->m_Sock, c, strlen(c),0);
        if (iRet == -1)
        {
             printf("Erreur lors de l'envoi de l'accuse de reception du nom de joueur\n");
             //exit(1);
        }
    }
    
    iRet = recv(this->m_Sock, c, sizeof(c),0);
    if (iRet == -1)
    {
        printf("Erreur lors de la reception du go du serveur\n");
        //exit(5);
    }
}

//retourne le numero du joueur
int SGReseau::getNumJoueur()
{
    return (int)this->m_cNumJoueur;
}



// Renvoie le nombre de joueurs de la partie
int SGReseau::getNbJoueurs()
{
    return(this->m_iNbJoueurs);
}

// Renvoie le nom d'un joueur
char * SGReseau::getNomJoueur(int iNumJoueur)
{
    this->m_pListeJoueurs->debut();
    if (this->m_pListeJoueurs->getSize() == 0)
        return "Aucun";
    CellJoueur *pC;    
    do
    {
        pC = this->m_pListeJoueurs->getCourant();
        if (pC->cNumJoueur == (char)iNumJoueur)
        {
            return pC->szNomJoueur;
        }
    }while (this->m_pListeJoueurs->suivant());
    
    return "Aucun";
}
